#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "MZ-1E14.h"


#define SIOAD 0xF4     // SIO A Data
#define SIOBD 0xF5     // SIO B Data
#define SIOAC 0xF6     // SIO A Control
#define SIOBC 0xF7     // SIO B Control


#define SIOINTVECREG 2
#define SIORXCONTROLREG 3
 #define SIORXENABLEBIT 0x01
#define SIOTXCONTROLREG 5
 #define SIOTXCRCENABLE 0x01
 #define SIORTS 0x02
 #define SIOTXENABLEBIT 0x08
 #define SIOSENDBREAK 0x10
 #define SIODTR 0x80
#define SIOSYNCCHAR1REG 6
#define SIOSYNCCHAR2REG 7

#define QDHEADSET 0x08
#define QDHOME 0x08
#define QDMOTORBIT SIODTR
#define QDRXDENABLEBIT SIORTS


#define SIOHUNTPHASEBIT 0x10

#define QDOFF 0
#define QDREAD 1
#define QDWRITE 2

struct Z80SIO
{
 unsigned char ChaAData;
 unsigned char ChaAWReg[8];
 unsigned char ChaARReg[2];
 unsigned char ChaBData;
 unsigned char ChaBWReg[8];
 unsigned char ChaBRReg[3];
};




unsigned char MZ1E14 = FALSE;
unsigned char SIOACRegSelect = TRUE;
unsigned char SIOBCRegSelect = TRUE;
struct Z80SIO MZ1E14SIO;
unsigned short MZ1E14CRC16;

//#define QDFILE "a:/mz700.qd"
#define QDSIZE 61455
char QDFileName[80] = "a:\\mz-700.qd";
unsigned char QDArray[QDSIZE];
unsigned short QDPtr;


extern unsigned char MZExtROM[0x10000 - 0xE000];

extern void ReInitVGA(void);




UINT16 MZ1E14_Read(UINT16 Address)
{
 UINT16 Result;
 unsigned char Counter;
 FILE *QDFile;



 Result = 0xFF;


 switch(Address)
 {
  case SIOAD:
        Result = QDArray[QDPtr++];
        break;
  case SIOBD:
        break;
  case SIOAC:
        if(SIOACRegSelect == TRUE)
        {
         if((MZ1E14SIO.ChaAWReg[3] & SIOHUNTPHASEBIT) && (MZ1E14SIO.ChaAWReg[3] & SIORXENABLEBIT))
         {
          Counter = 8;
          do
          {
           if(QDPtr >= QDSIZE) QDPtr = 0;


           if(QDArray[QDPtr++] == MZ1E14SIO.ChaAWReg[SIOSYNCCHAR1REG])
           {
            if(QDArray[QDPtr++] == MZ1E14SIO.ChaAWReg[SIOSYNCCHAR2REG])
             MZ1E14SIO.ChaARReg[0] = MZ1E14SIO.ChaARReg[0] & ~SIOHUNTPHASEBIT;
            else
             QDPtr--;
           }

           Counter--;
          } while((Counter != 0) && (MZ1E14SIO.ChaARReg[0] & SIOHUNTPHASEBIT));
         }
         else
         {


          if(!(MZ1E14SIO.ChaBWReg[SIOTXCONTROLREG] & QDMOTORBIT))
          {
           if((QDFile = fopen(QDFileName, "rb")) != NULL)
           {
            fclose(QDFile);
            // QD image found, so floppy is in drive
            MZ1E14SIO.ChaARReg[0] = MZ1E14SIO.ChaARReg[0] | 0x08;
            if((QDFile = fopen(QDFileName, "rb+")) != NULL)
            {
             fclose(QDFile);
             // QD image is also writble, so not writeprotected
             MZ1E14SIO.ChaARReg[0] = MZ1E14SIO.ChaARReg[0] | 0x20;
            }
           }
           else
           {
            if((QDFile = fopen(QDFileName, "wb")) != NULL)
            {
             memset(QDArray, 0, QDSIZE);
             fwrite(QDArray, QDSIZE, 1, QDFile);
             fclose(QDFile);
             // QD image is created, so disk is in drive and not writeprotected
             MZ1E14SIO.ChaARReg[0] = MZ1E14SIO.ChaARReg[0] | 0x28;
            }
            else
            {
             // QD image was not readable and not able to create, so no disk and protected
             MZ1E14SIO.ChaARReg[0] = MZ1E14SIO.ChaARReg[0] & 0xD7;
            }
           }
          }

         }
         Result = MZ1E14SIO.ChaARReg[0];
        }
        else
        {
         Result = MZ1E14SIO.ChaARReg[MZ1E14SIO.ChaAWReg[0] & 0x07];
         SIOACRegSelect = TRUE;
        }
        break;
  case SIOBC:
        if(SIOBCRegSelect == TRUE)
        {

         if((MZ1E14SIO.ChaAWReg[SIOTXCONTROLREG] & 0x1A) == 0x0A)
         {
          if(MZ1E14CRC16 != 0)
          {
           QDArray[QDPtr++] = 'C';
           QDArray[QDPtr++] = 'R';
           QDArray[QDPtr++] = 'C';


           if(QDPtr >= QDSIZE)
           {
            QDPtr = 0;
            Result = 0x00;
           }
           else Result = 0x08;
          }
          else
          {
           if(QDPtr == 0)
           {
            Result = 0x08;
           }
           else
           {
            QDPtr++;
            if(QDPtr >= QDSIZE)
            {
             QDPtr = 0;
             Result = 0x00;
            }
            else Result = 0x08;
           }
          }
         }

         if(MZ1E14SIO.ChaAWReg[SIORXCONTROLREG] & SIORXENABLEBIT)
         {
          // search for home position
          if(QDPtr == 0)
          {
           Result = 0x00;
           QDPtr++;
          }
          else
          {
           QDPtr++;
           if(QDPtr >= QDSIZE)
           {
            QDPtr = 0;
            Result = 0x00;
           }
           else Result = 0x08;

          }
         }
        }
        else
        {
         Result = MZ1E14SIO.ChaBRReg[MZ1E14SIO.ChaBWReg[0] & 0x07];
         SIOBCRegSelect = TRUE;
        }
        break;
 }

 return(Result);
}




void MZ1E14_Write(UINT16 Address, UINT8 Data)
{
 unsigned char Counter;
 FILE *QDFile;


 switch(Address)
 {
  case SIOAD:
        QDArray[QDPtr++] = Data;
        MZ1E14CRC16 = MZ1E14CRC16 ^ Data;
        break;
  case SIOBD:
        break;
  case SIOAC:
        if(SIOACRegSelect)
        {
         MZ1E14SIO.ChaAWReg[0] = Data;
         if((Data & 0xC0) == 0x80) MZ1E14CRC16 = 0;
         if((Data & 0x38) == 0x18)
         {
          // channel reset
          for(Counter = 0; Counter < 7; Counter++)
           MZ1E14SIO.ChaAWReg[Counter] = 0;
         }
         if((MZ1E14SIO.ChaAWReg[0] & 0x07) != 0) SIOACRegSelect = FALSE;
        }
        else
        {
         MZ1E14SIO.ChaAWReg[MZ1E14SIO.ChaAWReg[0] & 0x07] = Data;
         switch(MZ1E14SIO.ChaAWReg[0] & 0x07)
         {
          case SIORXCONTROLREG:
                if(MZ1E14SIO.ChaAWReg[SIORXCONTROLREG] & SIOHUNTPHASEBIT)
                 MZ1E14SIO.ChaARReg[0] = MZ1E14SIO.ChaARReg[0] | SIOHUNTPHASEBIT;
                break;
          case SIOTXCONTROLREG:
               if(MZ1E14SIO.ChaBWReg[SIOTXCONTROLREG] & QDMOTORBIT)
               {
                if((MZ1E14SIO.ChaAWReg[SIOTXCONTROLREG] & 0x18) == 0x18)
                {
                 QDArray[QDPtr++] = 0x00;    // Break
                }
                else
                {
                 if((MZ1E14SIO.ChaAWReg[SIOTXCONTROLREG] & 0x1A) == 0x0A)
                 {
                  QDArray[QDPtr++] = MZ1E14SIO.ChaAWReg[SIOSYNCCHAR1REG];
                  QDArray[QDPtr++] = MZ1E14SIO.ChaAWReg[SIOSYNCCHAR2REG];
                 }                 
                }
               }
                break;
         }
         SIOACRegSelect = TRUE;
        }
        break;
  case SIOBC:
        if(SIOBCRegSelect)
        {
         MZ1E14SIO.ChaBWReg[0] = Data;
         if((MZ1E14SIO.ChaBWReg[0] & 0x07) != 0) SIOBCRegSelect = FALSE;
        }
        else
        {
         switch(MZ1E14SIO.ChaBWReg[0] & 0x07)
         {
          case SIOINTVECREG:
               MZ1E14SIO.ChaBRReg[2] = Data;
               break;

          case SIOTXCONTROLREG:
               if(Data & QDMOTORBIT)
               {
                if(!(MZ1E14SIO.ChaBWReg[SIOTXCONTROLREG] & QDMOTORBIT))
                {                
                 // motor is first time on, so goto start
                 if((QDFile = fopen(QDFileName, "rb")) != NULL)
                 {
                  fread(QDArray, QDSIZE, 1, QDFile);
                  fclose(QDFile);
                  QDPtr = 0;
                 }
                }
               }
               else
               {
                if(MZ1E14SIO.ChaBWReg[SIOTXCONTROLREG] & QDMOTORBIT)
                {                


                 // motor is off, so goto end position
                 // stimmt nicht, es kann immer noch gearbeitet werden bis
                 // #HOME erreicht ist !!!

                 if((QDFile = fopen(QDFileName, "wb")) != NULL)
                 {
                  fwrite(QDArray, QDSIZE, 1, QDFile);
                  fclose(QDFile);
                  QDPtr = 0xFFFF;
                 }
                }

               }

         }
         MZ1E14SIO.ChaBWReg[MZ1E14SIO.ChaBWReg[0] & 0x07] = Data;

         
         SIOBCRegSelect = TRUE;
        }
        break;
 }
}




void LoadMZ1E14ROM(void)
{
 FILE *pROM;

 
 if((pROM = fopen("MZ-1E14.ROM", "rb")) != NULL)
 {
  fread(MZExtROM + 0x0800, sizeof(char), 0x10000 - 0xE800, pROM);
  fclose(pROM);

  MZ1E14SIO.ChaARReg[0] = 0x3D;
  MZ1E14SIO.ChaARReg[1] = 0x01;
  MZ1E14SIO.ChaBRReg[0] = 0x08;
 }
 else
 {
  ReInitVGA();
  printf("Can not open MZ-1E14.ROM !\n");
  exit(1);
 }
}
